<?php

function get_bundle_links($bundle_id)
{
    App::uses('Link', 'Model');
    $link = new Link();
    $count = $link->find('count', array(
        'conditions' => array('Link.bundle_id' => $bundle_id)
    ));
    return $count;
}
?>


<!-- BEGIN PAGE HEADER-->
<div class="row">
    <div class="col-sm-12">
        <!-- BEGIN PAGE TITLE & BREADCRUMB-->
        <h3 class="page-title">
            Manage Bundles
        </h3>
        <!-- END PAGE TITLE & BREADCRUMB-->
    </div>
</div>
<!-- END PAGE HEADER-->


<!-- BEGIN PAGE CONTENT-->
<div class="row">
    <div class="col-sm-12">
        
        <div class="pull-left">
            <?php
            // The base url is the url where we'll pass the filter parameters
            $base_url = array('controller' => 'bundles', 'action' => 'index');
            echo $this->Form->create('Filter', array(
                'url' => $base_url,
                'class' => 'form-inline',
                'inputDefaults' => array(
                    'label' => false,
                    'div' => 'form-group',
                    'class' => 'form-control input-sm',
                    'error' => array(
                        'attributes' => array('wrap' => 'span', 'class' => 'help-block')
                    ),
                ),
            ));
            ?>
            
            <?php echo $this->Form->input('name_desc', array('type' => 'text', 'placeholder' => __('name or Desc.'))); ?>
            
            <?php echo $this->Form->submit('Filter', array('div' => false, 'class' => 'btn btn-default btn-sm')); ?>
            <?php echo $this->Html->link('Reset', $base_url); ?>
            <?php echo $this->Form->end(); ?>
        </div>
        
        
        <div class="clearfix"></div>

        <?php foreach ($bundles as $bundle) : ?>
            <div class="box box-solid">
                <div class="box-body">
                    <h4>
                        <?php
                        $bundle_url = $this->Html->url(array('admin' => false, 'controller' => 'bundles', 'action' => 'view', 'username' => $this->Session->read('Auth.User.username'), 'id' => $bundle['Bundle']['user_bundle_id']), true);

                        echo '<a href="' . $bundle_url . '" target="_blank"><i class="fa fa-tag"></i> ' . h($bundle['Bundle']['name']) . '</a>';
                        ?>
                    </h4>
                    <p class="text-muted">
                        <small>
                            <i class="fa fa-calendar"></i> <?php echo $this->Time->niceShort($bundle['Bundle']['created']); ?> - 
                            <i class="fa fa-link"></i> <?php echo get_bundle_links($bundle['Bundle']['id']); ?> links -
                            <?php
                            if ($bundle['Bundle']['private']) {
                                echo '<i class="fa fa-lock"></i> Private -';
                            }
                            ?>
                            <i class="fa fa-eye"></i> <?php echo $bundle['Bundle']['views']; ?> Views.
                        </small>
                    </p>

                    <div class="row">
                        <div class="col-sm-6">
                            <input type="text" class="form-control input-sm" value = "<?php echo $bundle_url; ?>" readonly onfocus="javascript:this.select()">
                        </div>
                        <div class="col-sm-6">
                            <div class="text-right">
                                <button type="button" class="btn btn-info btn-sm copy-clipboard" data-clipboard-text="<?php echo $bundle_url; ?>"><i class="fa fa-clipboard"></i> Copy</button>
                                <?php echo $this->Html->link('<i class="fa fa-edit"></i> Edit', array('controller' => 'bundles', 'action' => 'edit', $bundle['Bundle']['id']), array('escape' => false, 'class' => 'btn btn-primary btn-sm'));
                                ?>
                                <?php
                                echo $this->Form->postLink(
                                    '<i class="fa fa-trash-o"></i> Delete',
                                    array('action' => 'delete', $bundle['Bundle']['id']),
                                    array('escape' => false, 'class' => 'btn btn-danger btn-sm', 'confirm' => 'Are you sure?')
                                );
                                ?>

                            </div>
                        </div>
                    </div>
                </div></div>
        <?php endforeach; ?>
        <?php unset($bundle); ?>


        <ul class="pagination">
            <!-- Shows the previous link -->
            <?php echo $this->Paginator->prev('«', array('tag' => 'li'), null, array('class' => 'disabled', 'tag' => 'li', 'disabledTag' => 'a')); ?>
            <!-- Shows the page numbers -->
            <?php //echo $this->Paginator->numbers();  ?>
            <?php
            echo $this->Paginator->numbers(array(
                'modulus' => 4,
                'separator' => '',
                'ellipsis' => '<li><a>...</a></li>',
                'tag' => 'li',
                'currentTag' => 'a',
                'first' => 2,
                'last' => 2
            ));
            ?>
            <!-- Shows the next link -->
            <?php echo $this->Paginator->next('»', array('tag' => 'li'), null, array('class' => 'disabled', 'tag' => 'li', 'disabledTag' => 'a')); ?>
        </ul>
        <br />
        <!-- prints X of Y, where X is current page and Y is number of pages -->
        <?php echo $this->Paginator->counter(); ?>


    </div>
</div>
<!-- END PAGE CONTENT-->